/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.RepositoryEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexChangedEvent
extends RepositoryEvent {
    private Collection<ChangedFile> diff;

    IndexChangedEvent(GitRepository repository, Collection<ChangedFile> preChangeFiles, Collection<ChangedFile> postChangeFiles) {
        super(repository);
        this.diff = CollectionsUtil.getNonOverlapping(preChangeFiles, postChangeFiles);
    }

    protected boolean hasDiff() {
        return !this.getDiff().isEmpty();
    }

    public Set<IResource> getFilesWithChanges() {
        Collection<ChangedFile> changedFiles = this.getDiff();
        GitRepository repo = this.getRepository();
        IPath workingDirectory = repo.workingDirectory();
        HashSet<IResource> files = new HashSet<IResource>(changedFiles.size());
        for (ChangedFile changedFile : changedFiles) {
            IPath path = workingDirectory.append(changedFile.getRelativePath()).makeAbsolute();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (file == null) continue;
            files.add((IResource)file);
        }
        return files;
    }

    private Collection<ChangedFile> getDiff() {
        return this.diff;
    }
}

